--Specjalizacja dla : Ursus1614 By Marcello1942
--#Autor: marcello1942
--#data: 15/05/2013 r.

Ursus1614 = {};

function Ursus1614.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus1614:load(xmlFile)

	local rotationPartNodedach = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dach#index"));
    if rotationPartNodedach ~= nil then
        self.rotationPartdach = {};
        self.rotationPartdach.node = rotationPartNodedach;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartdach#minRot"));
        self.rotationPartdach.minRot = {};
        self.rotationPartdach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.dach#maxRot"));
        self.rotationPartdach.maxRot = {};
        self.rotationPartdach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach#rotTime"), 2)*1000;
        self.rotationPartdach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach#touchRotLimit"), 10));
    end;
	local rotationPartNodedach1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dach1#index"));
    if rotationPartNodedach1 ~= nil then
        self.rotationPartdach1 = {};
        self.rotationPartdach1.node = rotationPartNodedach1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartdach1#minRot"));
        self.rotationPartdach1.minRot = {};
        self.rotationPartdach1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.dach1#maxRot"));
        self.rotationPartdach1.maxRot = {};
        self.rotationPartdach1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdach1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach1#rotTime"), 2)*1000;
        self.rotationPartdach1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach1#touchRotLimit"), 10));
    end;
	local rotationPartNodedach2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dach2#index"));
    if rotationPartNodedach2 ~= nil then
        self.rotationPartdach2 = {};
        self.rotationPartdach2.node = rotationPartNodedach2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartdach2#minRot"));
        self.rotationPartdach2.minRot = {};
        self.rotationPartdach2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.dach2#maxRot"));
        self.rotationPartdach2.maxRot = {};
        self.rotationPartdach2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdach2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach2#rotTime"), 2)*1000;
        self.rotationPartdach2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach2#touchRotLimit"), 10));
    end;

	local klapalewa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#lewe"));
	if klapalewa ~= nil then
		self.klapalewa = klapalewa;
	end;
		local klapaprawa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#prawe"));
	if klapaprawa ~= nil then
		self.klapaprawa = klapaprawa;
	end;
		local zaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#zaczep"));
	if zaczep ~= nil then
		self.zaczep = zaczep;
	end;
		local pompka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#pompka"));
	if pompka ~= nil then
		self.pompka = pompka;
	end;
	local one = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#one"));
	if one ~= nil then
		self.one = one;
	end;
	local two = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#two"));
	if two ~= nil then
		self.two = two;
	end;
	local three = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#three"));
	if three ~= nil then
		self.three = three;
	end;
	local four = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#four"));
	if four ~= nil then
		self.four = four;
	end;
	local szyba = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#szyba"));
	if szyba ~= nil then
		self.szyba = szyba;
	end;
	local right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#right"));
	if right ~= nil then
		self.right = right;
	end;
	local left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#left"));
	if left ~= nil then
		self.left = left;
	end;
	local compressor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#compressor"));
	if compressor ~= nil then
		self.compressor = compressor;
	end;
	
	
	self.klapkaoff = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.klapkaoff#index"));
	self.klapkaon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.klapkaon#index"));
	self.bolec1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bolec1#index"));
	self.bolec2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bolec2#index"));
	setVisibility((self.klapkaoff), true);
	setVisibility((self.klapkaon), false);
	

  	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);
	self.hydraulics = {};
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);
		self.hydraulics[i] = {};
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};

		local ax, ay, az;
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
    self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
    self.otworz = false
	self.zamknij = false
	
	
	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;
	
	
	local shaftCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.drivingPowerShafts#count"), 0);
    self.drivingPowerShafts = {};
    for i=1, shaftCount do
		local shaft = {};
        local shaftName = string.format("vehicle.drivingPowerShafts.powerShaft%d", i);
		shaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, shaftName .. "#index"));		
		shaft.trans = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#translation"), 0);
		local x,y,z = getTranslation(getParent(shaft.node));
		shaft.orgTrans = {x,y,z};
		shaft.rot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#rotation"), 0));	
		shaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#speedFactor"), 2);
		table.insert(self.drivingPowerShafts, shaft);        
    end;
	
	
	hor12nSoundFile = Utils.getFilename("sounds/otworzdrzwi.wav", self.baseDirectory);
    self.hor12nSoundId = createSample("LizardHor12nSound");
    loadSample(self.hor12nSoundId, hor12nSoundFile, false);
    self.hor12nPlaying = false;
	
	openSoundFile = Utils.getFilename("sounds/otworzdrzwi.wav", self.baseDirectory);
    self.openSoundId = createSample("LizardHor12nSound");
    loadSample(self.openSoundId, openSoundFile, false);
    self.openPlaying = false;
	
	clouseSoundFile = Utils.getFilename("sounds/zamknijdrzwi.wav", self.baseDirectory);
    self.clouseSoundId = createSample("LizardHor12nSound");
    loadSample(self.clouseSoundId, clouseSoundFile, false);
    self.clousePlaying = false;
    
    hor123nSoundFile = Utils.getFilename("sounds/zamknijdrzwi.wav", self.baseDirectory);
    self.hor123nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor123nSoundId, hor123nSoundFile, false);
    self.hor123nPlaying = false;
	
	hor1234nSoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.hor1234nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor1234nSoundId, hor1234nSoundFile, false);
    self.hor1234nPlaying = false;
	
	hor12345nSoundFile = Utils.getFilename("sounds/bieg2.wav", self.baseDirectory);
    self.hor12345nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor12345nSoundId, hor12345nSoundFile, false);
    self.hor12345nPlaying = false;
	
	hor123456nSoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.hor123456nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor123456nSoundId, hor123456nSoundFile, false);
    self.hor123456nPlaying = false;
	
	hor1234567nSoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.hor1234567nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor1234567nSoundId, hor1234567nSoundFile, false);
    self.hor1234567nPlaying = false;
	
	hor12345678nSoundFile = Utils.getFilename("sounds/bieg2.wav", self.baseDirectory);
    self.hor12345678nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor12345687nSoundId, hor12345678nSoundFile, false);
    self.hor12345678nPlaying = false;
	
	horn2SoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.horn2SoundId = createSample("LizardHor123nSound");
    loadSample(self.horn2SoundId, horn2SoundFile, false);
    self.horn2Playing = false;
	
	dach_downSoundFile = Utils.getFilename("sounds/dach_down.wav", self.baseDirectory);
    self.dach_downSoundId = createSample("LizardHor12nSound");
    loadSample(self.dach_downSoundId, dach_downSoundFile, false);
    self.dach_downPlaying = false;
	
	dach_upSoundFile = Utils.getFilename("sounds/dach_up.wav", self.baseDirectory);
    self.dach_upSoundId = createSample("LizardHor12nSound");
    loadSample(self.dach_upSoundId, dach_upSoundFile, false);
    self.dach_upPlaying = false;
	
	wajchaSoundFile = Utils.getFilename("sounds/wajcha.wav", self.baseDirectory);
    self.wajchaSoundId = createSample("LizardHor12nSound");
    loadSample(self.wajchaSoundId, wajchaSoundFile, false);
    self.wajchaPlaying = false;
	
	wajcha1SoundFile = Utils.getFilename("sounds/wajcha.wav", self.baseDirectory);
    self.wajcha1SoundId = createSample("LizardHor12nSound");
    loadSample(self.wajcha1SoundId, wajcha1SoundFile, false);
    self.wajcha1Playing = false;
	
	podnosnikSoundFile = Utils.getFilename("sounds/podnosnik.wav", self.baseDirectory);
    self.podnosnikSoundId = createSample("LizardHor12nSound");
    loadSample(self.podnosnikSoundId, podnosnikSoundFile, false);
    self.podnosnikPlaying = false;
	
	
	pstrykSoundFile = Utils.getFilename("sounds/pstryk.wav", self.baseDirectory);
    self.pstrykSoundId = createSample("LizardHor12nSound");
    loadSample(self.pstrykSoundId, pstrykSoundFile, false);
    self.pstrykPlaying = false;
	
	pstryk1SoundFile = Utils.getFilename("sounds/pstryk.wav", self.baseDirectory);
    self.pstryk1SoundId = createSample("LizardHor12nSound");
    loadSample(self.pstryk1SoundId, pstryk1SoundFile, false);
    self.pstryk1Playing = false;
	
	bolecSoundFile = Utils.getFilename("sounds/bolec.wav", self.baseDirectory);
    self.bolecSoundId = createSample("LizardHor12nSound");
    loadSample(self.bolecSoundId, bolecSoundFile, false);
    self.bolecPlaying = false;
	
	bolec2SoundFile = Utils.getFilename("sounds/bolec.wav", self.baseDirectory);
    self.bolec2SoundId = createSample("LizardHor12nSound");
    loadSample(self.bolec2SoundId, bolec2SoundFile, false);
    self.bolec2Playing = false;
	
	compressorSoundFile = Utils.getFilename("sounds/compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("LizardHor12nSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	brakeSoundFile = Utils.getFilename("sounds/brake.wav", self.baseDirectory);
    self.brakeSoundId = createSample("LizardHor12nSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	
end;
 function Ursus1614:delete()
end;
function Ursus1614:keyEvent(unicode, sym, modifier, isDown)
	  
	  	if isDown and sym == Input.KEY_t then 
		self.rotationMaxdach = not self.rotationMaxdach;
	end;
 
	if isDown and sym == Input.KEY_t then 
		self.rotationMaxdach1 = not self.rotationMaxdach1;
	end; 
	if isDown and sym == Input.KEY_t then 
		self.rotationMaxdach2 = not self.rotationMaxdach2;
	end; 

	if isDown and sym == Input.KEY_b then
		self.Przekaznik = not self.Przekaznik;
	end;
	
	
	if isDown and sym == Input.KEY_b then
		self.wajcha = not self.wajcha;
	end;
	
	
	if isDown and sym == Input.KEY_w then
		self.front = not self.front;
	end;
	
	
	if isDown and sym == Input.KEY_s then
		self.backward = not self.backward;
	end;
	
	
	if isDown and sym == Input.KEY_v then
		self.podnosnik = not self.podnosnik;
	end;
	
	if isDown and sym == Input.KEY_l then
		self.wycieraczka = not self.wycieraczka;
	end;
	
	if isDown and sym == Input.KEY_l then
		self.wlacznik = not self.wlacznik;
	end;
		
  
end;


function Ursus1614:update(dt)

        local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	
		
		local px, py, pz = getWorldTranslation(self.klapalewa); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.przyklapiel = true; 
		else
			self.przyklapiel = false; 
		end;
		
		local rx, ry, rz = getWorldTranslation(self.klapaprawa); 
		local distance = Utils.vector3Length(rx-vx, ry-vy, rz-vz);	
		if distance < nearestDistance then
			self.przyklapiep = true; 
		else
			self.przyklapiep = false; 
		end;
		
		
		local sx, sy, sz = getWorldTranslation(self.zaczep); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
		if distance < nearestDistance then
			self.przyzaczepie = true; 
		else
			self.przyzaczepie = false; 
		end; 
		
		local ux, uy, uz = getWorldTranslation(self.pompka); 
		local distance = Utils.vector3Length(ux-vx, uy-vy, uz-vz);	
		if distance < nearestDistance then
			self.przypompka = true; 
		else
			self.przypompka = false; 
		end; 
		
		local ox, oy, oz = getWorldTranslation(self.bolec1); 
		local distance = Utils.vector3Length(ox-vx, oy-vy, oz-vz);	
		if distance < nearestDistance then
			self.przyBolec1 = true; 
		else
			self.przyBolec1 = false; 
		end; 
		
		local nx, ny, nz = getWorldTranslation(self.bolec2); 
		local distance = Utils.vector3Length(nx-vx, ny-vy, nz-vz);	
		if distance < nearestDistance then
			self.przyBolec2 = true; 
		else
			self.przyBolec2 = false; 
		end; 
		
		local mx, my, mz = getWorldTranslation(self.compressor); 
		local distance = Utils.vector3Length(mx-vx, my-vy, mz-vz);	
		if distance < nearestDistance then
			self.przycompressor = true; 
		else
			self.przycompressor = false; 
		end; 
	
		
		
--------drzwi----------------
--otwieranie--
	if self.przyklapiep or self.isEntered then
	if InputBinding.hasEvent(InputBinding.PRAWE) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
				self.otworz = true;
				self.zamknij = false;
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
				self.otworz = false;
				self.zamknij = true;
			end;
		end;
	end;
	
	if self.przyklapiel or self.isEntered then
	if InputBinding.hasEvent(InputBinding.LEWE) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
				self.sound7 = true;
				self.sound8 = false;
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
				self.sound7 = false;
				self.sound8 = true;
			end;
		end;
	end;  
	
	--dach-	
	if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.DACH) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
				self.sound11 = true;
				self.sound12 = false;
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
				self.sound11 = false;
				self.sound12 = true;
			end;
		end;
		end;
		
		--szyba_tyl-	
	if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.SZYBA) then
			if self.animationParts[45].clipEndTime then
				self:setAnimationTime(45, self.animationParts[45].offSet);
			elseif self.animationParts[45].clipStartTime then
				self:setAnimationTime(45, self.animationParts[45].animDuration);
			end;
		end;
	end;
	
	--zaczep--
	if self.przyzaczepie then
	 	if InputBinding.isPressed(InputBinding.zaczepP) then
               self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.zaczepL) then
               self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet+dt), false);
        end;
        end;
		
		--pompka--
	if self.przypompka then
	 	if InputBinding.isPressed(InputBinding.pompkaup) then
               self:setAnimationTime(24, self.animationParts[24].currentPosition+(self.animationParts[24].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.pompkadown) then
               self:setAnimationTime(24, self.animationParts[24].currentPosition-(self.animationParts[24].offSet+dt), false);
        end;
        end;
		
		---podnosnik---
	
	if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
			rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
			setRotation(self.Lifter.node, rBBArmX*1.5, 0, 0);
	end;
	if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
			setRotation(self.LifterArm.node, 0.05-rBBArmX*1.5, 0, 0);
	end;
	
	---wajcha podnosnika---
	
		if self.isEntered then
		if self.podnosnik then
		   self:setAnimationTime(5,self.animationParts[5].animDuration);
		   self.sound19 = true;
		else 
		   self:setAnimationTime(5,self.animationParts[5].offSet);	
           self.sound19 = false;   
		end;
		end;
		
		---wycieraczka---
		
		if self.wycieraczka then
           self:setAnimationTime(67, 1);
		   self.sound20 = true;
        else
           self:setAnimationTime(67, 0);
		   self.sound20 = false;
        end;
		
		if self.isEntered then
		if self.wlacznik then
			self:setAnimationTime(68,self.animationParts[68].animDuration);
			self.sound21 = true;
			self.sound22 = false;
		else
			self:setAnimationTime(68,self.animationParts[68].offSet);
			self.sound21 = false;
			self.sound22 = true;
		end;
		end;
	                 --- szyby boczne ---
					 
		if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.szybaL) then
			if self.animationParts[69].clipEndTime then
				self:setAnimationTime(69, self.animationParts[69].offSet);
			elseif self.animationParts[69].clipStartTime then
				self:setAnimationTime(69, self.animationParts[69].animDuration);
			end;
		end;
	end;		

        if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.szybaP) then
			if self.animationParts[70].clipEndTime then
				self:setAnimationTime(70, self.animationParts[70].offSet);
			elseif self.animationParts[70].clipStartTime then
				self:setAnimationTime(70, self.animationParts[70].animDuration);
			end;
		end;
	end;			 	
					 ---Reczny---
					 
	    if self.handbrake then
		    self:setAnimationTime(7,self.animationParts[7].animDuration);
		else
			self:setAnimationTime(7,self.animationParts[7].offSet);
		end;
		
		            ---siedzisko---
					
		if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.siedzenie) then
			if self.animationParts[71].clipEndTime then
				self:setAnimationTime(71, self.animationParts[71].offSet);
			elseif self.animationParts[71].clipStartTime then
				self:setAnimationTime(71, self.animationParts[71].animDuration);
			end;
		end;
	end;	

                    ---Compressor---
					
        if self.przycompressor then			
		if InputBinding.hasEvent(InputBinding.compressor) then
			if self.animationParts[72].clipEndTime then
				self:setAnimationTime(72, self.animationParts[72].offSet);
				self.sound25 = false;
			elseif self.animationParts[72].clipStartTime then
				self:setAnimationTime(72, self.animationParts[72].animDuration);
				self.sound25 = true;
			end;
		end;
	end;	
					
					---Bolce---
		if  InputBinding.hasEvent(InputBinding.bolec1) and self.przyBolec1 then
			self.boolec1 = not self.boolec1;
	    end;

		if self.boolec1 then
			setVisibility(self.bolec1,true);
			self.sound23 = true;
		else
			setVisibility(self.bolec1,false);
			self.sound23 = false;
		end;
		
        if  InputBinding.hasEvent(InputBinding.bolec1) and self.przyBolec2 then
			self.boolec2 = not self.boolec2;
	    end;

		if self.boolec2 then
			setVisibility(self.bolec2,true);
			self.sound24 = true;
		else
			setVisibility(self.bolec2,false);
			self.sound24 = false;
		end;
					---Panel pomocy---
					
		if  InputBinding.hasEvent(InputBinding.help) then
			self.help = not self.help;
	    end;			
		
					------------------
		
	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(6, 1);
		else
			self:setAnimationTime(6, 0);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(8, 1);
		else
			self:setAnimationTime(8, 0);
		end;
		if self.Przekaznik then
           self:setAnimationTime(9, 1);
        else
           self:setAnimationTime(9, 0);
        end;
	    if self.isMotorStarted then
			self:setAnimationTime(11,self.animationParts[11].animDuration);
		else
			self:setAnimationTime(11,self.animationParts[11].offSet);
		end;
		 if self.lastSpeed*3600 > 3 then
			self:setAnimationTime(12,self.animationParts[12].animDuration);
		else
			self:setAnimationTime(12,self.animationParts[12].offSet);
		end;
		 if self.lastSpeed*3600 > 6 then
			self:setAnimationTime(13,self.animationParts[13].animDuration);
		else
			self:setAnimationTime(13,self.animationParts[13].offSet);
		end;
		 if self.lastSpeed*3600 > 9 then
			self:setAnimationTime(14,self.animationParts[14].animDuration);
		else
			self:setAnimationTime(14,self.animationParts[14].offSet);
		end;
		 if self.lastSpeed*3600 > 12 then
			self:setAnimationTime(15,self.animationParts[15].animDuration);
		else
			self:setAnimationTime(15,self.animationParts[15].offSet);
		end;
		if self.lastSpeed*3600 > 15 then
			self:setAnimationTime(16,self.animationParts[16].animDuration);
		else
			self:setAnimationTime(16,self.animationParts[16].offSet);
		end;
		 if self.lastSpeed*3600 > 18 then
			self:setAnimationTime(17,self.animationParts[17].animDuration);
		else
			self:setAnimationTime(17,self.animationParts[17].offSet);
		end;
		if self.lastSpeed*3600 > 21 then
			self:setAnimationTime(18,self.animationParts[18].animDuration);
		else
			self:setAnimationTime(18,self.animationParts[18].offSet);
		end;
		 if self.lastSpeed*3600 > 24 then
			self:setAnimationTime(19,self.animationParts[19].animDuration);
		else
			self:setAnimationTime(19,self.animationParts[19].offSet);
		end;
		if self.lastSpeed*3600 > 27 then
			self:setAnimationTime(20,self.animationParts[20].animDuration);
		else
			self:setAnimationTime(20,self.animationParts[20].offSet);
		end;
		 if self.lastSpeed*3600 > 30 then
			self:setAnimationTime(21,self.animationParts[21].animDuration);
		else
			self:setAnimationTime(21,self.animationParts[21].offSet);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(22,self.animationParts[22].animDuration);
		else
			self:setAnimationTime(22,self.animationParts[22].offSet);
		end;
		
		if self.isEntered then
		if self.hamuj then
			self:setAnimationTime(23,self.animationParts[23].animDuration);
			self.sound10 = true;
		else
			self:setAnimationTime(23,self.animationParts[23].offSet);
			self.sound10 = false;
		end;
		end;
		
		
		if self.isEntered then
		if self.wajcha then
			self:setAnimationTime(10,self.animationParts[10].animDuration);
			self.sound17 = true;
			self.sound18 = false;
		else
			self:setAnimationTime(10,self.animationParts[10].offSet);
			self.sound17 = false;
			self.sound18 = true;
		end;
		end;
		if self.lastSpeed*3600 > 4 then
			self:setAnimationTime(26,self.animationParts[26].animDuration);
		else
			self:setAnimationTime(26,self.animationParts[26].offSet);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(25, 1);
		else
			self:setAnimationTime(25, 0);
		end;
		 if self.lastSpeed*3600 > 33 then
			self:setAnimationTime(28,self.animationParts[28].animDuration);
		else
			self:setAnimationTime(28,self.animationParts[28].offSet);
		end;
		 if self.lastSpeed*3600 > 36 then
			self:setAnimationTime(29,self.animationParts[29].animDuration);
		else
			self:setAnimationTime(29,self.animationParts[29].offSet);
		end;
		 if self.lastSpeed*3600 > 39 then
			self:setAnimationTime(30,self.animationParts[30].animDuration);
		else
			self:setAnimationTime(30,self.animationParts[30].offSet);
		end;
		 if self.lastSpeed*3600 > 42 then
			self:setAnimationTime(31,self.animationParts[31].animDuration);
		else
			self:setAnimationTime(31,self.animationParts[31].offSet);
		end;
		if self.lastSpeed*3600 > 45 then
			self:setAnimationTime(32,self.animationParts[32].animDuration);
		else
			self:setAnimationTime(32,self.animationParts[32].offSet);
		end;
		 if self.lastSpeed*3600 > 48 then
			self:setAnimationTime(33,self.animationParts[33].animDuration);
		else
			self:setAnimationTime(33,self.animationParts[33].offSet);
		end;
		if self.lastSpeed*3600 > 51 then
			self:setAnimationTime(34,self.animationParts[34].animDuration);
		else
			self:setAnimationTime(34,self.animationParts[34].offSet);
		end;
		 if self.lastSpeed*3600 > 54 then
			self:setAnimationTime(35,self.animationParts[35].animDuration);
		else
			self:setAnimationTime(35,self.animationParts[35].offSet);
		end;
		if self.lastSpeed*3600 > 57 then
			self:setAnimationTime(36,self.animationParts[36].animDuration);
		else
			self:setAnimationTime(36,self.animationParts[36].offSet);
		end;
		 if self.lastSpeed*3600 > 60 then
			self:setAnimationTime(37,self.animationParts[37].animDuration);
		else
			self:setAnimationTime(37,self.animationParts[37].offSet);
		end;
		
                         --- gearBox marcello1942---		
		
		if self.motor.speedLevel == 4 then
			self:setAnimationTime(41,self.animationParts[41].animDuration);
			self.two = false;
			self.three = false;
			self.one = false;
			self.sound = true;
		else
			self:setAnimationTime(41,self.animationParts[41].offSet);
			self.sound = false;
		end;
		if self.isEntered then
		if self.motor.speedLevel == 3 or Input.isKeyPressed(Input.KEY_w) then
			self:setAnimationTime(40,self.animationParts[40].animDuration);
			self.two = false;
			self.one = false;
			self.four = false;
			self.sound3 = true;
		else
			self:setAnimationTime(40,self.animationParts[40].offSet);
			self.sound3 = false;
		end;
		end;
		if self.motor.speedLevel == 2 then
			self:setAnimationTime(39,self.animationParts[39].animDuration);
			self.one = false;
			self.three = false;
			self.four = false;
			self.sound4 = true;
		else
			self:setAnimationTime(39,self.animationParts[39].offSet);
			self.sound4 = false;
		end;
		if self.isEntered then
		if self.motor.speedLevel == 1 or Input.isKeyPressed(Input.KEY_s) then
			self:setAnimationTime(38,self.animationParts[38].animDuration);
			self.two = false;
			self.three = false;
			self.four = false;
			self.sound6 = true;
		else
			self:setAnimationTime(38,self.animationParts[38].offSet);
			self.sound6 = false;
		end;
		end;
		
		if Input.isKeyPressed(Input.KEY_1) or Input.isKeyPressed(Input.KEY_2) or Input.isKeyPressed(Input.KEY_3) or Input.isKeyPressed(Input.KEY_4) then
		   self:setAnimationTime(42,self.animationParts[42].animDuration);
		else 
		   self:setAnimationTime(42,self.animationParts[42].offSet); 
		end;
		
		if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
		   self:setAnimationTime(43,self.animationParts[43].animDuration);
		   self:setAnimationTime(63,self.animationParts[63].animDuration);
		else 
		   self:setAnimationTime(43,self.animationParts[43].offSet);
		   self:setAnimationTime(63,self.animationParts[63].offSet);
		end;
		end;
				
        if self.front then
			self.two = false;
			self.one = false;
			self.four = false;
		end;
		
		if self.backward then
			self.two = false;
			self.four = false;
			self.three = false;
		end;
		
		                       ---FB---
							   
		if self.isEntered then					   
		if Input.isKeyPressed(Input.KEY_s) then
		   self:setAnimationTime(44, self.animationParts[44].currentPosition+(self.animationParts[44].offSet+dt), false);
		   self.sound2 = true;
		   self.sound5 = false;
        elseif 
		   Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel == 1 or self.motor.speedLevel == 2 or self.motor.speedLevel == 3 or self.motor.speedLevel == 4 then
           self:setAnimationTime(44, self.animationParts[44].currentPosition-(self.animationParts[44].offSet+dt), false);
		   self.sound2 = false;
		   self.sound5 = true;
        end;
        end;
		end;
		
		                 ---wskazowki---
						 
		if self.isMotorStarted then
			self:setAnimationTime(46,self.animationParts[46].animDuration);
		else
			self:setAnimationTime(46,self.animationParts[46].offSet);
		end;
        if self.isMotorStarted then
			self:setAnimationTime(47,self.animationParts[47].animDuration);
		else
			self:setAnimationTime(47,self.animationParts[47].offSet);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(48,self.animationParts[48].animDuration);
		else
			self:setAnimationTime(48,self.animationParts[48].offSet);
		end;
		
		
		if self.isMotorStarted and self.fuelFillLevel > 4 then
		self:setAnimationTime(49,self.animationParts[49].animDuration);
		else
			self:setAnimationTime(49,self.animationParts[49].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 8 then
		self:setAnimationTime(50,self.animationParts[50].animDuration);
		else
			self:setAnimationTime(50,self.animationParts[50].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 12 then
		self:setAnimationTime(51,self.animationParts[51].animDuration);
		else
			self:setAnimationTime(51,self.animationParts[51].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 16 then
		self:setAnimationTime(52,self.animationParts[52].animDuration);
		else
			self:setAnimationTime(52,self.animationParts[52].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 20 then
		self:setAnimationTime(53,self.animationParts[53].animDuration);
		else
			self:setAnimationTime(53,self.animationParts[53].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 24 then
		self:setAnimationTime(54,self.animationParts[54].animDuration);
		else
			self:setAnimationTime(54,self.animationParts[54].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 28 then
		self:setAnimationTime(55,self.animationParts[55].animDuration);
		else
			self:setAnimationTime(55,self.animationParts[55].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 32 then
		self:setAnimationTime(56,self.animationParts[56].animDuration);
		else
			self:setAnimationTime(56,self.animationParts[56].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 36 then
		self:setAnimationTime(57,self.animationParts[57].animDuration);
		else
			self:setAnimationTime(57,self.animationParts[57].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 40 then
		self:setAnimationTime(58,self.animationParts[58].animDuration);
		else
			self:setAnimationTime(58,self.animationParts[58].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 44 then
		self:setAnimationTime(59,self.animationParts[59].animDuration);
		else
			self:setAnimationTime(59,self.animationParts[59].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 48 then
		self:setAnimationTime(60,self.animationParts[60].animDuration);
		else
			self:setAnimationTime(60,self.animationParts[60].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 52 then
		self:setAnimationTime(61,self.animationParts[61].animDuration);
		else
			self:setAnimationTime(61,self.animationParts[61].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 56 then
		self:setAnimationTime(62,self.animationParts[62].animDuration);
		else
			self:setAnimationTime(62,self.animationParts[62].offSet);
		end;
		
		                        ---r---
		if self.isMotorStarted and self.fuelFillLevel < 12 then
		self:setAnimationTime(66,self.animationParts[66].animDuration);
		else
			self:setAnimationTime(66,self.animationParts[66].offSet);
		end;					
		
		                ---przelacznik kierunki---
						
		if  self.isEntered then				
		if  self.lewy then
			self:setAnimationTime(64,self.animationParts[64].animDuration);
			self.right = false;
		else
			self:setAnimationTime(64,self.animationParts[64].offSet);
		end;
        end;
        if  self.isEntered then		
 		if  self.prawy then
			self:setAnimationTime(65,self.animationParts[65].animDuration);
			self.left = false;
		else
			self:setAnimationTime(65,self.animationParts[65].offSet);
		end;
        end;

                            --klapka--
	  
	  if self.isMotorStarted then
		 setVisibility((self.klapkaoff), false);
		 setVisibility((self.klapkaon), true);
		 else
		 setVisibility((self.klapkaoff), true);
		 setVisibility((self.klapkaon), false);
	  end;		

	
		
	  --napisy
		if self.przyzaczepie then
			g_currentMission:addHelpButtonText(g_i18n:getText("RearHitchUp"), InputBinding.zaczepUp);
			g_currentMission:addHelpButtonText(g_i18n:getText("RearHitchDown"), InputBinding.zaczepDown);
		end;
		if self.przyklapiel then
	    if self.animationParts[2].clipStartTime then
			g_currentMission:addHelpButtonText(g_i18n:getText("DoorOpen"), InputBinding.LEWE);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("DoorClose"), InputBinding.LEWE);
		end;
		end;
		if self.przyklapiep then
	    if self.animationParts[1].clipStartTime then
			g_currentMission:addHelpButtonText(g_i18n:getText("DoorOpen"), InputBinding.PRAWE);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("DoorClose"), InputBinding.PRAWE);
		end;
		end
		if self.przypompka then
			g_currentMission:addHelpButtonText(g_i18n:getText("ManualPumpUp"), InputBinding.pompkaup);
			g_currentMission:addHelpButtonText(g_i18n:getText("ManualPumpDown"), InputBinding.pompkadown);
		end;
		if self.przyBolec1 then
		if self.boolec1 then
			g_currentMission:addHelpButtonText(g_i18n:getText("ShowPivot"), InputBinding.bolec1);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("HidePivot"), InputBinding.bolec1);
		end;
		end;
		if self.przyBolec2 then
		if self.boolec2 then
			g_currentMission:addHelpButtonText(g_i18n:getText("ShowPivot"), InputBinding.bolec1);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("HidePivot"), InputBinding.bolec1);
		end;
		end;
		if self.isEntered then
		if self.help then
		    g_currentMission:addHelpButtonText(g_i18n:getText("HideHelp"), InputBinding.help);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp"), InputBinding.help);
		end;
		end;
		if self.przycompressor then	
		if self.animationParts[72].clipStartTime then	
		    g_currentMission:addHelpButtonText(g_i18n:getText("CompressorOn"), InputBinding.compressor);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("CompressorOff"), InputBinding.compressor);
		end;
		end;

			if self:getIsActive() then
		self.setHydraulicTime = 30;
	end;


	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
	
	
	  if self.otworz then
       if not self.hor12nPlaying then
            playSample(self.hor12nSoundId, 1, 3, 3);
            self.hor12nPlaying = true;
        end;
       
    else
        if self.hor12nPlaying then
            stopSample(self.hor12nSoundId);
            self.hor12nPlaying = false;
        end;
         
    end;
      if self.zamknij then
       if not self.hor123nPlaying then
            playSample(self.hor123nSoundId, 1, 3, 3);
            self.hor123nPlaying = true;
        end;
       
    else
        if self.hor123nPlaying then
            stopSample(self.hor123nSoundId);
            self.hor123nPlaying = false;
        end;
         
    end;
	
	if self.sound then
       if not self.hor1234nPlaying then
            playSample(self.hor1234nSoundId, 1, 3, 3);
            self.hor1234nPlaying = true;
        end;
       
    else
        if self.hor1234nPlaying then
            stopSample(self.hor1234nSoundId);
            self.hor1234nPlaying = false;
        end;
         
    end;
	
	if self.sound2 then
       if not self.hor12345nPlaying then
            playSample(self.hor12345nSoundId, 1, 3, 3);
            self.hor12345nPlaying = true;
        end;
       
    else
        if self.hor12345nPlaying then
            stopSample(self.hor12345nSoundId);
            self.hor12345nPlaying = false;
        end;
         
    end;
	
	if self.sound3 then
       if not self.hor123456nPlaying then
            playSample(self.hor123456nSoundId, 1, 3, 3);
            self.hor123456nPlaying = true;
        end;
       
    else
        if self.hor123456nPlaying then
            stopSample(self.hor123456nSoundId);
            self.hor123456nPlaying = false;
        end;
         
    end;
	
	if self.sound4 then
       if not self.hor1234567nPlaying then
            playSample(self.hor1234567nSoundId, 1, 3, 3);
            self.hor1234567nPlaying = true;
        end;
       
    else
        if self.hor1234567nPlaying then
            stopSample(self.hor1234567nSoundId);
            self.hor1234567nPlaying = false;
        end;
         
    end;
	
	if self.sound5 then
       if not self.hor12345678nPlaying then
            playSample(self.hor12345678nSoundId, 1, 3, 3);
            self.hor12345678nPlaying = true;
        end;
       
    else
        if self.hor12345678nPlaying then
            stopSample(self.hor12345678nSoundId);
            self.hor12345678nPlaying = false;
        end;
         
    end;
	
	if self.sound6 then
       if not self.horn2Playing then
            playSample(self.horn2SoundId, 1, 3, 3);
            self.horn2Playing = true;
        end;
       
    else
        if self.horn2Playing then
            stopSample(self.horn2SoundId);
            self.horn2Playing = false;
        end;
         
    end;
	
	if self.sound7 then
       if not self.openPlaying then
            playSample(self.openSoundId, 1, 3, 3);
            self.openPlaying = true;
        end;
       
    else
        if self.openPlaying then
            stopSample(self.openSoundId);
            self.openPlaying = false;
        end;
         
    end;
	
		if self.sound8 then
       if not self.clousePlaying then
            playSample(self.clouseSoundId, 1, 3, 3);
            self.clousePlaying = true;
        end;
       
    else
        if self.clousePlaying then
            stopSample(self.clouseSoundId);
            self.clousePlaying = false;
        end;
         
    end;
	
	if self.sound10 then
       if not self.brakePlaying then
            playSample(self.brakeSoundId, 1, 3, 3);
            self.brakePlaying = true;
        end;
       
    else
        if self.brakePlaying then
            stopSample(self.brakeSoundId);
            self.brakePlaying = false;
        end;
         
    end;
	
	if self.sound11 then
       if not self.dach_downPlaying then
            playSample(self.dach_downSoundId, 1, 3, 3);
            self.dach_downPlaying = true;
        end;
       
    else
        if self.dach_downPlaying then
            stopSample(self.dach_downSoundId);
            self.dach_downPlaying = false;
        end;
         
    end;
	
	if self.sound12 then
       if not self.dach_upPlaying then
            playSample(self.dach_upSoundId, 1, 3, 3);
            self.dach_upPlaying = true;
        end;
       
    else
        if self.dach_upPlaying then
            stopSample(self.dach_upSoundId);
            self.dach_upPlaying = false;
        end;
         
    end;
	
	if self.sound17 then
       if not self.wajchaPlaying then
            playSample(self.wajchaSoundId, 1, 3, 3);
            self.wajchaPlaying = true;
        end;
       
    else
        if self.wajchaPlaying then
            stopSample(self.wajchaSoundId);
            self.wajchaPlaying = false;
        end;
         
    end;
	
	if self.sound18 then
       if not self.wajcha1Playing then
            playSample(self.wajcha1SoundId, 1, 3, 3);
            self.wajcha1Playing = true;
        end;
       
    else
        if self.wajcha1Playing then
            stopSample(self.wajcha1SoundId);
            self.wajcha1Playing = false;
        end;
         
    end;
	
	if self.sound19 then
       if not self.podnosnikPlaying then
            playSample(self.podnosnikSoundId, 1, 3, 3);
            self.podnosnikPlaying = true;
        end;
       
    else
        if self.podnosnikPlaying then
            stopSample(self.podnosnikSoundId);
            self.podnosnikPlaying = false;
        end;
         
    end;
	
	
	if self.sound21 then
       if not self.pstrykPlaying then
            playSample(self.pstrykSoundId, 1, 3, 3);
            self.pstrykPlaying = true;
        end;
       
    else
        if self.pstrykPlaying then
            stopSample(self.pstrykSoundId);
            self.pstrykPlaying = false;
        end;
         
    end;
	
	if self.sound22 then
       if not self.pstryk1Playing then
            playSample(self.pstryk1SoundId, 1, 3, 3);
            self.pstryk1Playing = true;
        end;
       
    else
        if self.pstryk1Playing then
            stopSample(self.pstryk1SoundId);
            self.pstryk1Playing = false;
        end;
         
    end;
	
	if self.sound23 then
       if not self.bolecPlaying then
            playSample(self.bolecSoundId, 1, 3, 3);
            self.bolecPlaying = true;
        end;
       
    else
        if self.bolecPlaying then
            stopSample(self.bolecSoundId);
            self.bolecPlaying = false;
        end;
         
    end;
	
	if self.sound24 then
       if not self.bolec2Playing then
            playSample(self.bolec2SoundId, 1, 3, 3);
            self.bolec2Playing = true;
        end;
       
    else
        if self.bolec2Playing then
            stopSample(self.bolec2SoundId);
            self.bolec2Playing = false;
        end;
         
    end;
	
	if self.sound25 then
       if not self.compressorPlaying then
            playSample(self.compressorSoundId, 0, 1, 0);
            self.compressorPlaying = true;
        end;
       
    else
        if self.compressorPlaying then
            stopSample(self.compressorSoundId);
            self.compressorPlaying = false;
        end;
		if self.rotationPartdach ~= nil then
		   local x, y, z = getRotation(self.rotationPartdach.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdach.maxRot, self.rotationPartdach.minRot, 3, self.rotationPartdach.rotTime, dt, not self.rotationMaxdach);
		   setRotation(self.rotationPartdach.node, unpack(newRot));
        end;
		
		if self.rotationPartdach1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartdach1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdach1.maxRot, self.rotationPartdach1.minRot, 3, self.rotationPartdach1.rotTime, dt, not self.rotationMaxdach1);
		   setRotation(self.rotationPartdach1.node, unpack(newRot));
        end;
		if self.rotationPartdach2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartdach2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdach2.maxRot, self.rotationPartdach2.minRot, 3, self.rotationPartdach2.rotTime, dt, not self.rotationMaxdach2);
		   setRotation(self.rotationPartdach2.node, unpack(newRot));
        end;
         
    end;
	
	
	
end;


function Ursus1614:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ursus1614:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
function Ursus1614:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;
function Ursus1614:draw()

        if self.isEntered then
		if self.help then
			renderText(0.67, 0.825, 0.03, "-->Ursus 1604<--");
			if not self.isMotorStarted then
			renderText(0.72, 0.800, 0.02, "Z: turn on the engine");
			else
			renderText(0.72, 0.800, 0.02, "Z: turn off the engine");
			end;
	
	
		    renderText(0.72, 0.775, 0.02, "Doors right: M, left: N ");		
         
           
			renderText(0.72, 0.750, 0.02, "Direction indicators: Num 1/2/3 ");
	
		
			renderText(0.72, 0.725, 0.02, "Add, reduce rpm: Num_plus, Num_minus ");
			
			
			renderText(0.72, 0.700, 0.02, "Halogens: 7, 8 ");
			
			
			renderText(0.72, 0.675, 0.02, "Handbrake: Space ");
			
			
			renderText(0.72, 0.650, 0.02, "Passenger seat: J ");
			
			
			renderText(0.72, 0.625, 0.02, "***Turn on the fourth gear");
			
			
			renderText(0.72, 0.600, 0.02, "to get the maximum speed***");
			
			
			renderText(0.72, 0.575, 0.02, "Side windows, left: Y, right: U");
			
			
			renderText(0.72, 0.550, 0.02, "Rear window: K");
			
			
		end;
	end;	
end;

function Ursus1614:updateTick(dt)
		if self.backHydraulic ~= nil then		
		local x, y, z = getRotation(self.attacherJoints[1].bottomArm.rotationNode);
		setRotation(self.backHydraulic.rootArm, x, y, z);	
	end;
	
	

		for _, shaft in pairs(self.drivingPowerShafts) do
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(shaft.node, 0 ,0, x*shaft.speedFactor);
			
			if shaft.trans ~= 0 then
				local newTrans = shaft.trans * self.articulatedSteering.curRot/self.articulatedSteering.maxRot;
				local x,y,z = unpack(shaft.orgTrans);
				setTranslation(getParent(shaft.node), x + newTrans,y,z);
			end;
			if shaft.rot ~= 0 then
				newRot = shaft.rot * self.articulatedSteering.curRot/self.articulatedSteering.maxRot;
				setRotation(getParent(shaft.node), 0, newRot, 0);
			end;
    end;		
end;